/*
 * Decompiled with CFR 0.152.
 */
package xeij;

import java.awt.datatransfer.DataFlavor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.LinkedList;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import xeij.Assembler;
import xeij.ComponentFactory;
import xeij.Disassembler;
import xeij.ExpressionEvaluator;
import xeij.MC68060;
import xeij.Multilingual;
import xeij.RestorableFrame;
import xeij.ScrollTextArea;
import xeij.XEiJ;

public class DebugConsole {
    public static final int DGT_MAX_OUTPUT_LENGTH = 0x100000;
    public static final int DGT_CUT_OUTPUT_LENGTH = 0x110000;
    public static final int DGT_INPUT_MODE_COMMAND = 1;
    public static final int DGT_INPUT_MODE_PAGE = 2;
    public static final int DGT_INPUT_MODE_ASSEMBLER = 3;
    public static int dgtInputMode;
    public static LinkedList<String> dgtPageList;
    public static final String DGT_COMMAND_PROMPT = "> ";
    public static final String DGT_PAGE_PROMPT = "-- more -- [y/n] ";
    public static String dgtCurrentPrompt;
    public static JFrame dgtFrame;
    public static ScrollTextArea dgtBoard;
    public static JPopupMenu dgtPopupMenu;
    public static JMenuItem dgtPopupCutMenuItem;
    public static JMenuItem dgtPopupCopyMenuItem;
    public static JMenuItem dgtPopupPasteMenuItem;
    public static JMenuItem dgtPopupSelectAllMenuItem;
    public static int dgtOutputEnd;
    public static volatile int dgtRequestRegs;
    public static int dgtAssemblePC;
    public static int dgtAssembleFC;
    public static int dgtDisassembleLastTail;
    public static int dgtDisassemblePC;
    public static int dgtDisassembleFC;
    public static int dgtDumpAddress;
    public static int dgtDumpFunctionCode;
    public static int dgtDumpStraddleChar;

    public static void dgtInit() {
        dgtInputMode = 1;
        dgtPageList = null;
        dgtCurrentPrompt = DGT_COMMAND_PROMPT;
        dgtFrame = null;
        dgtBoard = null;
        dgtPopupMenu = null;
        dgtPopupCutMenuItem = null;
        dgtPopupCopyMenuItem = null;
        dgtPopupPasteMenuItem = null;
        dgtPopupSelectAllMenuItem = null;
        dgtOutputEnd = dgtCurrentPrompt.length();
        dgtRequestRegs = 0;
        dgtAssemblePC = 0;
        dgtAssembleFC = 6;
        dgtDisassembleLastTail = 0;
        dgtDisassemblePC = 0;
        dgtDisassembleFC = 6;
        dgtDumpAddress = 0;
        dgtDumpFunctionCode = 5;
        dgtDumpStraddleChar = 0;
    }

    public static void dgtMake() {
        String string = (Multilingual.mlnJapanese ? "[ h \u3067\u4f7f\u7528\u6cd5\u3092\u8868\u793a]\n" : "[enter h to display usage]\n") + dgtCurrentPrompt;
        dgtOutputEnd = string.length();
        dgtBoard = ComponentFactory.createScrollTextArea(string, 500, 600, true);
        dgtBoard.setUnderlineCursorOn(true);
        dgtBoard.setLineWrap(true);
        dgtBoard.addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent documentEvent) {
            }

            @Override
            public void insertUpdate(DocumentEvent documentEvent) {
                if (documentEvent.getOffset() < dgtOutputEnd) {
                    dgtOutputEnd += documentEvent.getLength();
                }
            }

            @Override
            public void removeUpdate(DocumentEvent documentEvent) {
                if (documentEvent.getOffset() < dgtOutputEnd) {
                    dgtOutputEnd -= Math.min(documentEvent.getLength(), dgtOutputEnd - documentEvent.getOffset());
                }
            }
        });
        dgtBoard.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                int n = keyEvent.getKeyCode();
                int n2 = keyEvent.getModifiersEx();
                if (n == 10 && (n2 & 0x380) == 0) {
                    if ((n2 & 0x40) == 0) {
                        keyEvent.consume();
                        DebugConsole.dgtEnter();
                    } else {
                        keyEvent.consume();
                        dgtBoard.replaceRange("\n", dgtBoard.getSelectionStart(), dgtBoard.getSelectionEnd());
                    }
                }
            }
        });
        ActionListener actionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                switch (actionEvent.getActionCommand()) {
                    case "Cut": {
                        DebugConsole.dgtCut();
                        break;
                    }
                    case "Copy": {
                        DebugConsole.dgtCopy();
                        break;
                    }
                    case "Paste": {
                        DebugConsole.dgtPaste();
                        break;
                    }
                    case "Select All": {
                        DebugConsole.dgtSelectAll();
                    }
                }
            }
        };
        JComponent[] jComponentArray = new JComponent[5];
        dgtPopupCutMenuItem = Multilingual.mlnText(ComponentFactory.createMenuItem("Cut", 84, actionListener), "ja", "\u5207\u308a\u53d6\u308a");
        jComponentArray[0] = dgtPopupCutMenuItem;
        dgtPopupCopyMenuItem = Multilingual.mlnText(ComponentFactory.createMenuItem("Copy", 67, actionListener), "ja", "\u30b3\u30d4\u30fc");
        jComponentArray[1] = dgtPopupCopyMenuItem;
        dgtPopupPasteMenuItem = Multilingual.mlnText(ComponentFactory.createMenuItem("Paste", 80, actionListener), "ja", "\u8cbc\u308a\u4ed8\u3051");
        jComponentArray[2] = dgtPopupPasteMenuItem;
        jComponentArray[3] = ComponentFactory.createHorizontalSeparator();
        dgtPopupSelectAllMenuItem = Multilingual.mlnText(ComponentFactory.createMenuItem("Select All", 65, actionListener), "ja", "\u3059\u3079\u3066\u9078\u629e");
        jComponentArray[4] = dgtPopupSelectAllMenuItem;
        dgtPopupMenu = ComponentFactory.createPopupMenu(jComponentArray);
        dgtBoard.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                DebugConsole.dgtShowPopup(mouseEvent);
            }

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
                DebugConsole.dgtShowPopup(mouseEvent);
            }
        });
        dgtFrame = Multilingual.mlnTitle(ComponentFactory.createRestorableSubFrame("dgt", "Console", null, dgtBoard), "ja", "\u30b3\u30f3\u30bd\u30fc\u30eb");
        dgtBoard.setCaretPosition(dgtOutputEnd);
    }

    public static void dgtShowPopup(MouseEvent mouseEvent) {
        if (mouseEvent.isPopupTrigger()) {
            boolean bl = XEiJ.clpClipboard != null && dgtBoard.getSelectionStart() != dgtBoard.getSelectionEnd();
            ComponentFactory.setEnabled(dgtPopupCutMenuItem, bl);
            ComponentFactory.setEnabled(dgtPopupCopyMenuItem, bl);
            ComponentFactory.setEnabled(dgtPopupPasteMenuItem, XEiJ.clpClipboard != null && XEiJ.clpClipboard.isDataFlavorAvailable(DataFlavor.stringFlavor));
            ComponentFactory.setEnabled(dgtPopupSelectAllMenuItem, XEiJ.clpClipboard != null);
            dgtPopupMenu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
        }
    }

    public static void dgtCut() {
        if (XEiJ.clpClipboard != null) {
            XEiJ.clpClipboardString = dgtBoard.getSelectedText();
            try {
                XEiJ.clpClipboard.setContents(XEiJ.clpStringContents, XEiJ.clpClipboardOwner);
                XEiJ.clpIsClipboardOwner = true;
            }
            catch (Exception exception) {
                return;
            }
            dgtBoard.replaceRange("", dgtBoard.getSelectionStart(), dgtBoard.getSelectionEnd());
        }
    }

    public static void dgtCopy() {
        String string;
        if (XEiJ.clpClipboard != null && (string = dgtBoard.getSelectedText()) != null) {
            XEiJ.clpClipboardString = string;
            try {
                XEiJ.clpClipboard.setContents(XEiJ.clpStringContents, XEiJ.clpClipboardOwner);
                XEiJ.clpIsClipboardOwner = true;
            }
            catch (Exception exception) {
                return;
            }
        }
    }

    public static void dgtPaste() {
        if (XEiJ.clpClipboard != null) {
            String string = null;
            try {
                string = (String)XEiJ.clpClipboard.getData(DataFlavor.stringFlavor);
            }
            catch (Exception exception) {
                return;
            }
            dgtBoard.replaceRange(string, dgtBoard.getSelectionStart(), dgtBoard.getSelectionEnd());
        }
    }

    public static void dgtSelectAll() {
        if (XEiJ.clpClipboard != null) {
            dgtBoard.selectAll();
        }
    }

    public static void dgtStart() {
        if (RestorableFrame.rfmGetOpened("dgt")) {
            DebugConsole.dgtOpen();
        }
    }

    public static void dgtOpen() {
        if (dgtFrame == null) {
            DebugConsole.dgtMake();
        }
        XEiJ.pnlExitFullScreen(false);
        dgtFrame.setVisible(true);
    }

    public static void dgtPrintChar(int n) {
        if (n == 8) {
            if (0 < dgtOutputEnd && dgtBoard != null) {
                dgtBoard.replaceRange("", dgtOutputEnd - 1, dgtOutputEnd);
                dgtBoard.setCaretPosition(--dgtOutputEnd);
            }
        } else if ((32 <= n && n != 127 || n == 9 || n == 10) && dgtBoard != null) {
            dgtBoard.insert(String.valueOf((char)n), dgtOutputEnd);
            if (0x110000 <= ++dgtOutputEnd) {
                dgtBoard.replaceRange("", 0, dgtOutputEnd - 0x100000);
                dgtOutputEnd = 0x100000;
            }
            dgtBoard.setCaretPosition(dgtOutputEnd);
        }
    }

    public static void dgtPrint(String string) {
        if (string == null) {
            return;
        }
        if (dgtFrame != null) {
            dgtBoard.insert(string, dgtOutputEnd);
            if (0x110000 <= (dgtOutputEnd += string.length())) {
                dgtBoard.replaceRange("", 0, dgtOutputEnd - 0x100000);
                dgtOutputEnd = 0x100000;
            }
            dgtBoard.setCaretPosition(dgtOutputEnd);
        }
    }

    public static void dgtPrintln(String string) {
        DebugConsole.dgtPrint(string);
        DebugConsole.dgtPrintChar(10);
    }

    public static void dgtEnter() {
        int n;
        String string = dgtBoard.getText();
        int n2 = string.length();
        int n3 = string.lastIndexOf(10, dgtOutputEnd - 1) + 1;
        if (n3 <= (n = string.lastIndexOf(10, dgtBoard.getCaretPosition() - 1) + 1)) {
            dgtBoard.replaceRange("", dgtOutputEnd, n2);
            DebugConsole.dgtSend(string.substring(dgtOutputEnd, n2));
        } else if (n3 < dgtOutputEnd) {
            String string2;
            int n4;
            String string3 = string.substring(n3, dgtOutputEnd);
            int n5 = string.indexOf(10, n);
            if (n5 == -1) {
                n5 = n2;
            }
            if (0 <= (n4 = (string2 = string.substring(n, n5)).indexOf(string3))) {
                dgtOutputEnd = n2;
                if (string.charAt(dgtOutputEnd - 1) != '\n' && !string.endsWith("\n" + string3)) {
                    dgtBoard.insert("\n", dgtOutputEnd);
                    if (0x110000 <= ++dgtOutputEnd) {
                        dgtBoard.replaceRange("", 0, dgtOutputEnd - 0x100000);
                        dgtOutputEnd = 0x100000;
                    }
                }
                dgtBoard.setCaretPosition(dgtOutputEnd);
                DebugConsole.dgtSend(string2.substring(n4 + string3.length()));
            }
        }
    }

    public static void dgtSend(String string) {
        DebugConsole.dgtPrintln(string);
        if (dgtInputMode == 1) {
            ExpressionEvaluator.ExpressionElement expressionElement = XEiJ.fpuBox.evxParse(string, 2);
            if (expressionElement != null) {
                expressionElement.exlEval(2);
                if (expressionElement.exlValueType == ExpressionEvaluator.ElementType.ETY_FLOAT) {
                    DebugConsole.dgtPrintln(expressionElement.exlFloatValue.toString());
                } else if (expressionElement.exlValueType == ExpressionEvaluator.ElementType.ETY_STRING) {
                    DebugConsole.dgtPrintln(expressionElement.exlStringValue);
                }
            }
        } else if (dgtInputMode == 2) {
            if (!(string.equals("") || string.toLowerCase().startsWith(" ") || string.toLowerCase().startsWith("y"))) {
                dgtPageList = null;
            }
            DebugConsole.dgtPrintPage();
        } else if (dgtInputMode == 3) {
            if (string.equals(".")) {
                dgtInputMode = 1;
                dgtCurrentPrompt = DGT_COMMAND_PROMPT;
            } else {
                byte[] byArray = Assembler.asmAssemble(dgtAssemblePC, string);
                if (byArray != null && 0 < byArray.length) {
                    int n;
                    for (n = 0; n < byArray.length; ++n) {
                        MC68060.mmuPokeByte(dgtAssemblePC + n, byArray[n], dgtAssembleFC);
                    }
                    n = dgtAssemblePC;
                    dgtAssemblePC += byArray.length;
                    DebugConsole.dgtMakeAssemblerPrompt();
                    int n2 = dgtAssembleFC & 4;
                    StringBuilder stringBuilder = new StringBuilder();
                    while (n < dgtAssemblePC) {
                        int n3;
                        int n4;
                        String string2 = Disassembler.disDisassemble(new StringBuilder(), n, n2).toString();
                        int n5 = Disassembler.disPC;
                        if (dgtAssemblePC < n5) {
                            n5 = dgtAssemblePC;
                            StringBuilder stringBuilder2 = new StringBuilder();
                            stringBuilder2.append("dc.w    ");
                            for (n4 = n; n4 < n5; n4 += 2) {
                                if (n < n4) {
                                    stringBuilder2.append(',');
                                }
                                XEiJ.fmtHex4(stringBuilder2.append('$'), MC68060.mmuPeekWordZeroCode(n4, n2));
                            }
                            string2 = stringBuilder2.toString();
                        }
                        int n6 = n;
                        n4 = Math.min(n6 + 10, n5);
                        XEiJ.fmtHex8(stringBuilder, n6).append("  ");
                        for (n3 = n6; n3 < n4; n3 += 2) {
                            XEiJ.fmtHex4(stringBuilder, MC68060.mmuPeekWordZeroCode(n3, n2));
                        }
                        stringBuilder.append(XEiJ.DBG_SPACES, 0, 2 * Math.max(0, n6 + 10 - n4) + 2);
                        stringBuilder.append(string2).append('\n');
                        while (n4 < n5) {
                            n6 = n4;
                            n4 = Math.min(n6 + 10, n5);
                            XEiJ.fmtHex8(stringBuilder, n6).append("  ");
                            for (n3 = n6; n3 < n4; n3 += 2) {
                                XEiJ.fmtHex4(stringBuilder, MC68060.mmuPeekWordZeroCode(n3, n2));
                            }
                            stringBuilder.append('\n');
                        }
                        n = n5;
                    }
                    DebugConsole.dgtPrint(stringBuilder.toString());
                }
            }
        }
        if (dgtRequestRegs == 0) {
            DebugConsole.dgtPrintPrompt();
        }
    }

    public static void dgtMakeAssemblerPrompt() {
        StringBuilder stringBuilder = XEiJ.fmtHex8(new StringBuilder(), dgtAssemblePC);
        if (6 <= XEiJ.currentMPU) {
            stringBuilder.append('@').append(dgtAssembleFC);
        }
        dgtCurrentPrompt = stringBuilder.append("  ").toString();
    }

    public static void dgtPrintPrompt() {
        String string = dgtBoard.getText();
        if (!string.substring(string.lastIndexOf(10, dgtOutputEnd - 1) + 1, dgtOutputEnd).equals(dgtCurrentPrompt)) {
            DebugConsole.dgtPrint((String)(string.endsWith("\n") ? dgtCurrentPrompt : "\n" + dgtCurrentPrompt));
        }
    }

    public static void dgtPrintPage() {
        if (dgtPageList != null && !dgtPageList.isEmpty()) {
            DebugConsole.dgtPrint(dgtPageList.pollFirst());
            if (!dgtPageList.isEmpty()) {
                dgtInputMode = 2;
                dgtCurrentPrompt = DGT_PAGE_PROMPT;
            }
        }
        if (dgtPageList == null || dgtPageList.isEmpty()) {
            dgtPageList = null;
            dgtInputMode = 1;
            dgtCurrentPrompt = DGT_COMMAND_PROMPT;
        }
        DebugConsole.dgtPrintPrompt();
    }
}

